% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_rm_spike.R
\name{rm_spike}
\alias{rm_spike}
\title{Remove spikes}
\usage{
rm_spike(x, col_name, out_name = NULL, tolerance)
}
\arguments{
\item{x}{data frame or tibble with class Date or POSIX*
in the first column.}

\item{col_name}{string with column(s) name(s) where to apply the function.}

\item{out_name}{optional. String with new column(s) name(s).
If you set it as \code{NULL}, the function will overwrite the
original table.}

\item{tolerance}{numeric vector with the maximum tolerance between
a number and its successor. If you provide a single value it will
be recycled.}
}
\value{
The same table but with the peaks removed.
}
\description{
Remove spikes and set their value as \code{NA_real_}.
}
\examples{

# set path to file
path_file <- system.file('extdata', 'ianigla_cuevas.csv',
             package = 'hydrotoolbox')

# read with default names
cuevas <- read_ianigla(path = path_file,
                       out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                                    'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                                    'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)') )

# remove spikes in snow heigh series
cuevas \%>\%
  rm_spike(col_name = 'hsnow(cm)',
           out_name = 'hsnow',
           tolerance = 50) # 50 cm of snow its OK for this zone


}
