% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_hm_get.R
\name{hm_get}
\alias{hm_get}
\alias{hm_get,hydromet-method}
\alias{hm_get,hydromet_station-method}
\alias{hm_get,hydromet_compact-method}
\title{Extract the slot}
\usage{
hm_get(obj, slot_name = NA_character_)

\S4method{hm_get}{hydromet}(obj, slot_name = NA_character_)

\S4method{hm_get}{hydromet_station}(obj, slot_name = NA_character_)

\S4method{hm_get}{hydromet_compact}(obj, slot_name = NA_character_)
}
\arguments{
\item{obj}{an \code{hydromet} or \code{hydromet_XXX} class object.}

\item{slot_name}{string with slot to extract.}
}
\value{
The required data frame or metadata.
}
\description{
Get the table (or metadata) that you want from an \code{hydromet} or \code{hydromet_XXX} class.
}
\section{Functions}{
\itemize{
\item \code{hm_get(hydromet)}: get method for generic hydromet object

\item \code{hm_get(hydromet_station)}: get method for station class

\item \code{hm_get(hydromet_compact)}: get method for compact class

}}
\examples{
\dontrun{
# set path to file
path_file <- system.file('extdata', 'ianigla_cuevas.csv',
             package = 'hydrotoolbox')

# read file
cuevas <-
     read_ianigla(path = path_file,
                  out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                             'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                              'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' ) )

# create and set one the variables
hm_cuevas <-
      hm_create() \%>\%
      hm_set(tair = cuevas[ , c('date', 'tair(°C)')])

# now extract the slot of air temperature
head( hm_get(obj = hm_cuevas, slot_name = 'tair') )
}

}
