% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mutation.R
\name{Mutation}
\alias{Mutation}
\title{Performing mutation\cr}
\usage{
Mutation(
  myParent,
  EVAoutput,
  r1,
  r2,
  initial.temp = 1000,
  cooling.rate = 0.95,
  X,
  y,
  heredity = "Strong",
  sigma,
  varind = NULL,
  interaction.ind = NULL,
  lambda = 10
)
}
\arguments{
\item{myParent}{A numeric matrix with dimension \code{numElite} by \code{r1 + r2}.}

\item{EVAoutput}{The output from function \code{EVA}.}

\item{r1}{At most how many main effects do you want to include in your model?.
For high-dimensional data, \code{r1} cannot be larger than the number of
screened main effects.}

\item{r2}{At most how many interaction effects do you want to include in your model?}

\item{initial.temp}{Initial temperature. Default is 1000.}

\item{cooling.rate}{A numeric value represents the speed at which the
temperature decreases. Default is 0.95.}

\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects.}

\item{y}{Response variable. A \code{n}-dimensional vector.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. Users can estimate sigma from function \code{selectiveInference::estimateSigma},
then use the output as the sigma value.}

\item{varind}{A numeric vector that specifies the indices of variables to be extracted from \code{X}.}

\item{interaction.ind}{A two-column numeric matrix. Each row represents a unique
interaction pair, with the columns indicating the index numbers of the variables
involved in each interaction. Note that interaction.ind must be generated
outside of this function using \code{t(utils::combn(p,2))}.}

\item{lambda}{A numeric value defined by users. The number needs to satisfy the condition:
\eqn{\lambda\geq 5.1/log(2)}. Default is 10.}
}
\value{
Mutant. A numeric matrix with dimensions \code{numElite} by \code{r1+r2}.
}
\description{
This function gives mutant from parents.
}
\examples{
set.seed(0)
interaction.ind <- t(combn(10,2))
X <- matrix(rnorm(100*10,1,0.1), 100, 10)
epl <- rnorm(100,0,0.01)
y <- 1+X[,1]+X[,2]+X[,3]+X[,1]*X[,2]+X[,1]*X[,3]+epl
EVAoutput <- EVA(X, y, r1 = 5, sigma = 0.01,
  interaction.ind = interaction.ind)
myParent <- Initial(X = X, y = y, EVAoutput, r1 = 5, r2 = 2)
Mutation(myParent, EVAoutput, r1 = 5, r2 = 2, X = X, y = y,
  sigma = 0.1, interaction.ind = interaction.ind)
}
\seealso{
\code{\link{EVA}}, \code{\link{Initial}}.
}
