% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-insert.R
\name{add_rows}
\alias{add_rows}
\alias{add_columns}
\title{Insert one huxtable into another}
\usage{
add_rows(x, y, after = nrow(x), copy_cell_props = TRUE)

add_columns(x, y, after = ncol(x), copy_cell_props = TRUE)
}
\arguments{
\item{x, y}{Huxtables or objects that can be converted by as_hux}

\item{after}{Row or column after which \code{y} is inserted. Can be 0.
Can be a row or column name. The default adds \code{y} to the
end of \code{x}.}

\item{copy_cell_props}{Logical. Passed to \code{\link[=rbind.huxtable]{rbind.huxtable()}} or
\code{\link[=cbind.huxtable]{cbind.huxtable()}}.}
}
\value{
A huxtable.
}
\description{
These functions combine two huxtables or similar objects and
return the result.
}
\details{
Arguments in \code{...} can include \code{copy_cell_props}.
}
\examples{

ht <- hux("Gooseberry", 2.15)
add_rows(jams, ht)
add_rows(jams, ht, after = 1)

mx <- matrix(
      c("Sugar", "50\%", "60\%", "40\%",
      "Weight (g)", 300, 250, 300),
      4, 2)
add_columns(jams, mx)
}
\seealso{
\code{\link[=insert_row]{insert_row()}} and \code{\link[=insert_column]{insert_column()}}, which insert
multiple values into a single row.
}
