% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{left_padding}
\alias{left_padding}
\alias{left_padding<-}
\alias{set_left_padding}
\alias{map_left_padding}
\alias{right_padding}
\alias{top_padding}
\alias{bottom_padding}
\alias{right_padding<-}
\alias{top_padding<-}
\alias{bottom_padding<-}
\alias{set_right_padding}
\alias{set_top_padding}
\alias{set_bottom_padding}
\alias{map_right_padding}
\alias{map_top_padding}
\alias{map_bottom_padding}
\title{Cell padding}
\usage{
left_padding(ht)
left_padding(ht) <- value
set_left_padding(ht, row, col, value, byrow = FALSE)
map_left_padding(ht, row, col, fn)

right_padding(ht)
right_padding(ht) <- value
set_right_padding(ht, row, col, value, byrow = FALSE)
map_right_padding(ht, row, col, fn)

top_padding(ht)
top_padding(ht) <- value
set_top_padding(ht, row, col, value, byrow = FALSE)
map_top_padding(ht, row, col, fn)

bottom_padding(ht)
bottom_padding(ht) <- value
set_bottom_padding(ht, row, col, value, byrow = FALSE)
map_bottom_padding(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or matrix. Characters must be valid CSS or LaTeX lengths. Numbers will be interpreted as lengths in points.

Set to \code{NA} to reset to the default, which is \code{4}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{left_padding}, the \code{left_padding} property.
For \code{set_left_padding} and \code{map_left_padding}, the modified huxtable.

Similarly for the other functions.
}
\description{
Functions to get or set the \emph{cell padding} property of huxtable cells.
}
\examples{

orig <- left_padding(jams)
left_padding(jams) <-  20
left_padding(jams)

left_padding(jams) <- orig

jams2 <- set_left_padding(jams,
      20)
left_padding(jams2)

jams3 <- set_left_padding(jams,
      2:3, 1, 20)
left_padding(jams3)

jams4 <- map_left_padding(jams,
      by_rows(
        20,
        10)
      )
left_padding(jams4)
}
