% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{print_md}
\alias{print_md}
\alias{to_md}
\alias{to_md.huxtable}
\title{Create Markdown representing a huxtable}
\usage{
print_md(ht, ...)

to_md(ht, ...)

\method{to_md}{huxtable}(ht, header = TRUE,
  min_width = getOption("width")/4, max_width = 80, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Arguments passed to methods.}

\item{header}{Logical. Print the first row as a header?}

\item{min_width}{Minimum width in on-screen characters of the result.}

\item{max_width}{Maximum width in on-screen characters of the result. Overrides \code{min_width}.}
}
\value{
\code{to_md} returns a string. \code{print_md} prints the string and returns
\code{NULL}.
}
\description{
Create Markdown representing a huxtable
}
\details{
Only \code{align} and \code{caption} properties are used. The markdown format is
\code{multiline_tables}, see the \href{http://rmarkdown.rstudio.com/authoring_pandoc_markdown.html#tables}{rmarkdown documentation}.
}
\examples{
ht <- huxtable(a = 1:5, b = 1:5)
print_md(ht)
}
\seealso{
Other printing functions: \code{\link{print_html}},
  \code{\link{print_latex}}, \code{\link{print_screen}}
}
