% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.huxtable}
\alias{print.huxtable}
\title{Default print method for huxtables}
\usage{
\method{print}{huxtable}(x, ...)
}
\arguments{
\item{x}{A huxtable.}

\item{...}{Options passed to other methods.}
}
\description{
By default huxtables are printed using \code{\link{print_screen}}. In certain cases, for example
in Sweave documents, it may be
useful to change this. You can do so by setting \code{options(huxtable.print)}.
}
\examples{
\dontrun{
# to print LaTeX output:
options(huxtable.print = print_latex)
# to print huxtables like data frames:
options(huxtable.print = function(x, ...) print(as.data.frame(x)))
}
}
