% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicated_rows.R
\name{duplicated_rows}
\alias{duplicated_rows}
\title{Return duplicated rows of data.table}
\usage{
duplicated_rows(DT, by = names(DT), na.rm = FALSE, order = TRUE,
  copyDT = TRUE, na.last = FALSE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{by}{Character vector of columns to evaluate duplicates over.}

\item{na.rm}{(logical) Should \code{NA}s in \code{by} be removed before returning duplicates? (Default \code{FALSE}.)}

\item{order}{(logical) Should the result be ordered so that duplicate rows are adjacent? (Default \code{TRUE}.)}

\item{copyDT}{(logical) Should \code{DT} be copied prior to detecting duplicates. If \code{FALSE}, the ordering of \code{DT} will be changed by reference.}

\item{na.last}{(logical) If \code{order} is TRUE, should \code{NA}s be ordered first or last?. Passed to \code{data.table::setorderv}.}
}
\value{
Duplicate rows of \code{DT} by \code{by}. For interactive use.
}
\description{
This function differs from \code{duplicated} in that it returns both the duplicate row and the row which has been duplicated.
This may prove useful in combination with the \code{by} argument for determining whether two observations are identical across
more than just the specified columns.
}
\examples{

if (requireNamespace("data.table", quietly = TRUE)) {
  library(data.table)

  DT <- data.table(x = rep(1:4, 3),
                   y = rep(1:2, 6),
                   z = rep(1:3, 4))

  # No duplicates
  duplicated_rows(DT)

  # x and y have duplicates
  duplicated_rows(DT, by = c("x", "y"), order = FALSE)

  # By default, the duplicate rows are presented adjacent to each other.
  duplicated_rows(DT, by = c("x", "y"))
}

}
