% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{WVP1}
\alias{WVP1}
\title{calculate partial water vapor pressure given dew point}
\usage{
WVP1(Td, isK = TRUE)
}
\arguments{
\item{Td}{dew point in Kelvin (K) or in degree Celsius (°C)}

\item{isK}{logical indicator whether temperature is in Kelvin (K). The default value is TRUE.}
}
\value{
numeric partial vapor pressure in hectopascal (hPa) or millibar (mb)
}
\description{
calculate partial water vapor pressure \eqn{e} based on dew point \eqn{T_d}
}
\examples{
T0 # absolute zero in Kelvin (K)
WVP1(T0)
}
\seealso{
\code{\link{SVP}}, \code{\link{SVP.ClaCla}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
