% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{startSnp}
\alias{startSnp}
\title{Find closest SNPs to the starts of ranges}
\usage{
startSnp(ranged = NULL, snp.info = NULL, chr = NULL, pos = NULL,
  start = T, end = F, nearest = T)
}
\arguments{
\item{ranged}{A GRanges or RangedData object specifying the range(s) you wish to find SNPs near the
starts of. Alternatively leave this parameter as NULL and specify ranges using chr, pos}

\item{snp.info}{ChipInfo/GRanges/Ranged data object describing the SNPs relevant to your query, e.g, 
SNPs on the chip you are using. If left NULL, the SNP set used will be that retrieved by chip.support()
which will depend on your options() settings, see ?chip.support for more info}

\item{chr}{optional alternative to 'ranged' input, use in conjunction with 'pos' to specify the ranges
to find the SNPs near the starts of.}

\item{pos}{matrix with 2 columns for start, end positions, or a single column if all ranges are SNPs.
An optional alternative to 'ranged' input, use in conjunction with 'chr' to specify the ranges
to find the SNPs near the starts of.}

\item{start}{logical whether to return the SNP nearest the range starts}

\item{end}{logical whether to return the SNP nearest the range ends}

\item{nearest}{will preferably find an exact match but if nearest=TRUE, will fall-back on nearest match, 
even if slightly outside the range.}
}
\value{
a list of SNP-ids (rownames of 'snp.info') fulfilling the criteria, the output will be a vector
which will have the same length as the input. Unless start=TRUE and end=TRUE, then will return a matrix
which should have the same number of rows as the number of ranges entered. Note that endSnp() is 
equivalent to using this function when end=TRUE and start=FALSE, and rangeSnp() is the same as setting
start=TRUE and end=TRUE.
}
\description{
For given genome ranges (GRanges/RangedData) will try to find the closest snps to the starts 
of the ranges.
}
\examples{
startSnp(chr=c(1:3),pos=cbind(c(100000,200000,300000),c(30000000,4000000,10000000)))
startSnp(rranges())
}

