% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{encodeURI}
\alias{decodeURI}
\alias{decodeURIComponent}
\alias{encodeURI}
\alias{encodeURIComponent}
\title{URI encoding/decoding}
\usage{
encodeURI(value)

encodeURIComponent(value)

decodeURI(value)

decodeURIComponent(value)
}
\arguments{
\item{value}{Character vector to be encoded or decoded.}
}
\value{
Encoded or decoded character vector of the same length as the
  input value.
}
\description{
Encodes/decodes strings using URI encoding/decoding in the same way that web
browsers do. The precise behaviors of these functions can be found at
developer.mozilla.org:
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURI}{encodeURI},
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent}{encodeURIComponent},
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURI}{decodeURI},
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURIComponent}{decodeURIComponent}
}
\details{
Intended as a faster replacement for \code{\link[utils]{URLencode}} and
\code{\link[utils]{URLdecode}}.

encodeURI differs from encodeURIComponent in that the former will not encode
reserved characters: \code{;,/?:@&=+$}

decodeURI differs from decodeURIComponent in that it will refuse to decode
encoded sequences that decode to a reserved character. (If in doubt, use
decodeURIComponent.)

The only way these functions differ from web browsers is in the encoding of
non-ASCII characters. All non-ASCII characters will be escaped byte-by-byte.
If conformant non-ASCII behavior is important, ensure that your input vector
is UTF-8 encoded before calling encodeURI or encodeURIComponent.
}

