% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignette.R
\name{start_vignette}
\alias{start_vignette}
\alias{end_vignette}
\title{Set mocking/capturing state for a vignette}
\usage{
start_vignette(path, ...)

end_vignette()
}
\arguments{
\item{path}{Root file path for the mocks for this vignette. A good idea is
to use the file name of the vignette itself.}

\item{...}{Optional arguments passed to \code{start_capturing()}}
}
\value{
Nothing; called for its side effect of starting/ending
response recording or mocking.
}
\description{
Use \code{start_vignette()} to either use previously recorded responses or capture
real responses for future use, depending on the value of the \code{RECORD}
environment variable.
}
\details{
In a vignette or other R Markdown or Sweave document, place
\code{start_vignette()} in an R code block at the beginning,
before the first API request is made, and put
\code{end_vignette()} in a R code chunk at the end. You may
want to make those R code chunks have \code{echo=FALSE} in order to hide the fact
that you're calling them.

The behavior changes based on the existence of the \code{path} directory. The
first time you build the vignette, the directory won't exist yet, so it will
make real requests and record them inside of \code{path}. On subsequent runs, the
mocks will be used. To record fresh responses from the server, delete the
\code{path} directory, and the responses will be recorded again the next time the
vignette runs.
}
\seealso{
\code{\link[=start_capturing]{start_capturing()}} for how requests are recorded; \code{\link[=use_mock_api]{use_mock_api()}}
for how previously recorded requests are loaded; \code{\link[=change_state]{change_state()}} for how to
handle recorded requests when the server state is changing;
\code{vignette("vignettes", package="httptest")} for an overview of all
}
