% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake-http.R
\name{fakeResponse}
\alias{fakeResponse}
\title{Return something that looks enough like an httr 'response'}
\usage{
fakeResponse(request, verb = "GET", status_code = 200, headers = list(),
  content = NULL)
}
\arguments{
\item{request}{An 'httr' \code{request}-class object. A character URL is also
accepted, for which a fake request object will be created, using the \code{verb}
argument as well. This behavior is deprecated.}

\item{verb}{Character name for the HTTP verb. Default is "GET". This argument
is deprecated; instead you should pass in a \code{request}}

\item{status_code}{Integer HTTP response status}

\item{headers}{Optional list of additional response headers to return}

\item{content}{If supplied, a JSON-serializable list that will be returned
as response content with Content-Type: application/json. If no \code{content}
is provided, and if the \code{status_code} is not 204 No Content, the
\code{url} will be set as the response content with Content-Type: text/plain.}
}
\value{
An 'httr' response class object.
}
\description{
These functions allow mocking of HTTP requests without requiring an internet
connection or server to run against. Their return shape is a 'httr'
"response" class object that should behave like a real response generated
by a real request.
}
