% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_id}
\alias{hgd_id}
\title{Query httpgd plot IDs}
\usage{
hgd_id(index = 0, limit = 1, which = dev.cur(), state = FALSE)
}
\arguments{
\item{index}{Plot index. If this is set to \code{0}, the last page will be
selected.}

\item{limit}{Limit the number of returned IDs. If this is set to a
value > 1 the returned type is a list if IDs.}

\item{which}{Which device (ID).}

\item{state}{Include the current device state in the returned result
(see also: \code{\link[=hgd_state]{hgd_state()}}).}
}
\value{
TODO
}
\description{
Query httpgd graphics device static plot IDs.
Available plot IDs starting from \code{index} will be returned.
\code{limit} specifies the number of plots.
This function will only work after starting a device with \code{\link[=hgd]{hgd()}}.
}
\examples{
\dontrun{

hgd()
plot.new()
text(.5, .5, "#1")
plot.new()
text(.5, .5, "#2")
plot.new()
text(.5, .5, "#3")
third <- hgd_id()
second <- hgd_id(2)
all <- hgd_id(1, limit = Inf)
hgd_remove(1)
hgd_svg(second)

dev.off()
}
}
