status_codes <- list(
  `100` = list('Continue', 'Request received, please continue'),
  `101` = list('Switching Protocols',
               'Switching to new protocol; obey Upgrade header'),
  `102` = list('Processing', 'WebDAV; RFC 2518'),

  `200` = list('OK', 'Request fulfilled, document follows'),
  `201` = list('Created', 'Document created, URL follows'),
  `202` = list('Accepted',
               'Request accepted, processing continues off-line'),
  `203` = list('Non-Authoritative Information', 'Request fulfilled from cache'),
  `204` = list('No Content', 'Request fulfilled, nothing follows'),
  `205` = list('Reset Content', 'Clear input form for further input.'),
  `206` = list('Partial Content', 'Partial content follows.'),
  `207` = list('Multi-Status', 'WebDAV; RFC 4918'),
  `208` = list('Already Reported', 'WebDAV; RFC 5842'),
  `226` = list('IM Used', 'RFC 3229'),

  `300` = list('Multiple Choices',
               'Object has several resources -- see URI list'),
  `301` = list('Moved Permanently', 'Object moved permanently -- see URI list'),
  `302` = list('Found', 'Object moved temporarily -- see URI list'),
  `303` = list('See Other', 'Object moved -- see Method and URL list'),
  `304` = list('Not Modified',
               'Document has not changed since given time'),
  `305` = list('Use Proxy',
               'You must use proxy specified in Location to access this resource.'),
  `306` = list('Switch Proxy', 'Subsequent requests should use the specified proxy'),
  `307` = list('Temporary Redirect',
               'Object moved temporarily -- see URI list'),
  `308` = list('Permanent Redirect', 'Object moved permanently'),

  `400` = list('Bad Request',
               'Bad request syntax or unsupported method'),
  `401` = list('Unauthorized',
               'No permission -- see authorization schemes'),
  `402` = list('Payment Required',
               'No payment -- see charging schemes'),
  `403` = list('Forbidden',
               'Request forbidden -- authorization will not help'),
  `404` = list('Not Found', 'Nothing matches the given URI'),
  `405` = list('Method Not Allowed',
               'Specified method is invalid for this resource.'),
  `406` = list('Not Acceptable', 'URI not available in preferred format.'),
  `407` = list('Proxy Authentication Required', 'You must authenticate with this proxy before proceeding.'),
  `408` = list('Request Timeout', 'Request timed out; try again later.'),
  `409` = list('Conflict', 'Request conflict.'),
  `410` = list('Gone',
               'URI no longer exists and has been permanently removed.'),
  `411` = list('Length Required', 'Client must specify Content-Length.'),
  `412` = list('Precondition Failed', 'Precondition in headers is false.'),
  `413` = list('Request Entity Too Large', 'Entity is too large.'),
  `414` = list('Request-URI Too Long', 'URI is too long.'),
  `415` = list('Unsupported Media Type', 'Entity body in unsupported format.'),
  `416` = list('Requested Range Not Satisfiable',
               'Cannot satisfy request range.'),
  `417` = list('Expectation Failed',
               'Expect condition could not be satisfied.'),
  `418` = list("I'm a teapot", 'The HTCPCP server is a teapot'),
  `419` = list('Authentication Timeout', 'previously valid authentication has expired'),
  `420` = list('Method Failure / Enhance Your Calm', 'Spring Framework / Twitter'),
  `422` = list('Unprocessable Entity', 'WebDAV; RFC 4918'),
  `423` = list('Locked', 'WebDAV; RFC 4918'),
  `424` = list('Failed Dependency / Method Failure', 'WebDAV; RFC 4918'),
  `425` = list('Unordered Collection', 'Internet draft'),
  `426` = list('Upgrade Required', 'client should switch to a different protocol'),

  `500` = list('Internal Server Error', 'Server got itself in trouble'),
  `501` = list('Not Implemented',
               'Server does not support this operation'),
  `502` = list('Bad Gateway', 'Invalid responses from another server/proxy.'),
  `503` = list('Service Unavailable',
               'The server cannot process the request due to a high load'),
  `504` = list('Gateway Timeout',
               'The gateway server did not receive a timely response'),
  `505` = list('HTTP Version Not Supported', 'Cannot fulfill request.'),
  `506` = list('Variant Also Negotiates', 'RFC 2295'),
  `507` = list('Insufficient Storage', 'WebDAV; RFC 4918'),
  `508` = list('Loop Detected', 'WebDAV; RFC 5842'),
  `509` = list('Bandwidth Limit Exceeded', 'Apache bw/limited extension')
)
