% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_volume_of_distribution.R
\name{calc_vdist}
\alias{calc_vdist}
\title{Calculate the volume of distribution for a one compartment model.}
\usage{
calc_vdist(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  suppress.messages = FALSE,
  adjusted.Funbound.plasma = TRUE,
  species = "Human",
  default.to.human = FALSE,
  ...
)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be specified
when Funbound.plasma is not given in parameter list.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified when Funbound.plasma is not given in parameter list.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from parameterize_3comp, parameterize_pbtk or
predict_partitioning_schmitt.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
\item{Volume of distribution}{Units of L/ kg BW.}
}
\description{
This function predicts partition coefficients for all tissues using
\code{\link{predict_partitioning_schmitt}}, then lumps them
into a single compartment.
}
\details{
The effective volume of distribution is calculated by summing each tissues
volume times it's partition coefficient relative to plasma. Plasma, and the
paritioning into RBCs are also added to get the total volume of distribution
in L/KG BW. Partition coefficients are calculated using Schmitt's (2008)
method.  When species is specified as rabbit, dog, or mouse, the function
uses the appropriate physiological data(volumes and flows) but substitues
human fraction unbound, partition coefficients, and intrinsic hepatic
clearance.
}
\examples{

calc_vdist(chem.cas="80-05-7")
calc_vdist(chem.name="Bisphenol A")
calc_vdist(chem.name="Bisphenol A",species="Rat")

# Create a list of parameters (that you can potentially change):
p <- parameterize_schmitt(chem.name="propranolol")
# Need to use those parameters to predict partition coefficients:
PCs <- predict_partitioning_schmitt(parameters = p)

# Lump the tissues into a single volume of distribution
calc_vdist(parameters=c(p,PCs))
# Should be the same as chemical by name:
calc_vdist(chem.name="propranolol")

# Different ways to give the arguments:
calc_vdist(chem.cas="80-05-7")
params <- parameterize_schmitt(chem.name="triclosan")
params <- c(params, predict_partitioning_schmitt(parameters = params))
calc_vdist(parameters=params)
params <- parameterize_3comp(chem.name="triclosan")
calc_vdist(parameters=params)
params <- parameterize_pbtk(chem.name="triclosan")
calc_vdist(parameters=params)

}
\references{
\insertRef{schmitt2008general}{httk}

\insertRef{peyret2010unified}{httk}
}
\seealso{
\code{\link{predict_partitioning_schmitt}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{1compartment}
\keyword{Parameter}
