% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lump_tissues.R
\name{lump_tissues}
\alias{lump_tissues}
\title{Lump tissue parameters into model compartments}
\usage{
lump_tissues(
  Ktissue2pu.in,
  parameters = NULL,
  tissuelist = NULL,
  species = "Human",
  tissue.vols = NULL,
  tissue.flows = NULL,
  tissuenames = NULL,
  model = "pbtk",
  suppress.messages = FALSE
)
}
\arguments{
\item{Ktissue2pu.in}{List of partition coefficients from
\code{predict_partitioning_schmitt}. The tissues named in this list are 
lumped into the compartments specified by \code{tissuelist} unless they are
not present the specified \code{model}'s associated \code{alltissues}.}

\item{parameters}{A list of physiological parameters including flows and
volumes for tissues named in \code{Ktissue2pu.in}}

\item{tissuelist}{Manually specifies compartment names and tissues, which
override the standard compartment names and tissues that are usually
specified in a model's associated modelinfo file. Remaining tissues in the
model's associated \code{alltissues} listing are lumped in the rest of the body.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{tissue.vols}{A list of volumes for tissues in \code{tissuelist}.}

\item{tissue.flows}{A list of flows for tissues in \code{tissuelist}.}

\item{tissuenames}{A list of tissue names in \code{tissuenames}.}

\item{model}{Specify which model (and therefore which tissues) are being 
considered.}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells
to unbound concentration in plasma.} \item{Krest2pu}{Ratio of concentration
of chemical in rest of body tissue to unbound concentration in plasma.}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
\item{Vliverc}{ Volume of the liver per kg body weight, L/kg BW.}
\item{Qtotal.liverf}{Fraction of cardiac output flowing to the gut and
liver, i.e. out of the liver.} \item{Qgutf}{Fraction of cardiac output
flowing to the gut.} \item{Qkidneyf}{Fraction of cardiac output flowing to
the kidneys.}
}
\description{
This function takes the tissue:plasma partition coefficients from 
\code{\link{predict_partitioning_schmitt}} along with the tissue-specific
volumes and flows and aggregates (or "lumps") them
according to the needed scheme of toxicokinetic model tissue comparments.

\code{\link{predict_partitioning_schmitt}} makes tissue-specific predictions
drawing from those tissues described in \code{\link{tissue.data}}. Since
different physiologically-based toxicokinetic (PBTK) models use diffeent 
schemes for rganizing the
tissues of the body into differing compartments (for example, "rapidly
perfused tissues"), this function lumps tissues into
compartments as specified by the argument 'tissuelist'. Aggregate flows, 
volumes, and partition coefficients are provided for the
lumped tissue compartments. Flows and volumes are summed while
partition coefficients is calculated using averaging weighted by 
species-specific tissue volumes.

The name of each entry in 'tissuelist' is its own compartment. The
modelinfo_MODEL.R file corresponding to the model specified by argument
'model' includes both a 'tissuelist' describing to the model's 
compartmentallumping schme as well as a vector of 'tissuenames' specifying 
all tissues to be lumped into those compartments.

Alternatively the 'tissuelist' and 'tissuenames' can also be manually
specified for alternate lumping schemes not necessarily related to a
pre-made httk model. For example,
tissuelist<-list(Rapid=c("Brain","Kidney")).

The tissues contained in 'tissuenames' that are unused in 'tissuelist' 
are aggregated into a single compartment termed
"rest".

NOTE: The partition coefficients of lumped compartments vary according to
individual and species differences since the volumes of the consitutent 
tissues may vary.
}
\examples{

 pcs <- predict_partitioning_schmitt(chem.name='bisphenola')
 tissuelist <- list(
   liver=c("liver"),
   rapid=c("lung","kidney","muscle","brain"),
   fat=c("adipose"),
   slow=c('bone'))
 lump_tissues(pcs,tissuelist=tissuelist)

}
\references{
\insertRef{pearce2017evaluation}{httk}
}
\seealso{
\code{\link{predict_partitioning_schmitt}}

\code{\link{tissue.data}}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
\keyword{pbtk}
