% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rblood2plasma.R
\name{get_rblood2plasma}
\alias{get_rblood2plasma}
\title{Get ratio of the blood concentration to the plasma concentration.}
\usage{
get_rblood2plasma(chem.name = NULL, chem.cas = NULL,
  species = "Human", default.to.human = F)
}
\arguments{
\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}
}
\description{
This function retrieves the in vivo ratio of the blood concentration to the
plasma concentration.
}
\details{
A value of NA is returned when the requested value is unavailable.  Values
are retrieved from chem.physical_and_invitro.data. %% ~~ If necessary, more
details than the description above ~~
}
\examples{

get_rblood2plasma(chem.name="Bisphenol A")
get_rblood2plasma(chem.name="Bisphenol A",species="Rat")

}
\author{
Robert Pearce
}
\keyword{Parameter}
