% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_wind.R
\name{p_wind}
\alias{p_wind}
\title{Plot wind roses}
\usage{
p_wind(
  data_wind,
  ws.int = 0.5,
  angle = 45,
  grid.line = 10,
  type = "default",
  breaks = 5,
  offset = 5,
  paddle = FALSE,
  key.position = "right"
)
}
\arguments{
\item{data_wind}{Name of the tibble containing the wind data}

\item{ws.int}{Size of speed intervals}

\item{angle}{Value in percent of the range unit}

\item{grid.line}{Value in percent of the grid line frequency}

\item{type}{Type of plot: "default", "year" or "month"}

\item{breaks}{Number of speed intervals}

\item{offset}{Size in percent of the central hole}

\item{paddle}{Shape of the basic elements: if FALSE, polar,
if TRUE, rectangular}

\item{key.position}{Position of the legend}
}
\value{
A wind rose plot
}
\description{
Plot wind roses using the "data_wind" tibble created with the
function \code{\link{d_wind}}.
}
\details{
For a detailed description of all parameters see \code{\link[openair]{windRose}}
}
\examples{
\dontrun{
p_wind (data_wind = data_wind)
}

}
\seealso{
\code{\link{d_wind}}, \code{\link[openair]{windRose}}
}
\author{
P. Chevallier - Dec 2019
}
