% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_scatter.R
\name{p_scatter}
\alias{p_scatter}
\title{Scatter plot of 2 or more time-series}
\usage{
p_scatter(
  files,
  intercept.zero = FALSE,
  remove.zero = FALSE,
  lg.axis = c(NA, NA),
  title = "Title"
)
}
\arguments{
\item{files}{List of file names to proceed}

\item{intercept.zero}{TRUE/FALSE (default) force the interception by origin}

\item{remove.zero}{TRUE / FALSE (default) remove the records with Value = 0
(e.g. precipitations)}

\item{lg.axis}{Legend list for axis x & y (default = NA)}

\item{title}{Title of the plot (default: Title)}
}
\value{
a table named "result" with 5 columns : variable name, size of the sample,
correlation coefficient, regression line slope, interception
}
\description{
The reference time-series is the first of the list. The scatter plot
regards only the common dates of the series. In addition to the plot, a linear function
is ajusted forcing or not the interception by the origin.
}
\examples{
\dontrun{

result <- p_scatter(files = c("foo1.RData","foo2.RData"),
          intercept.zero = TRUE)
}

}
\author{
P. Chevallier - Oct 2017-Jan 2019
}
