% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{kbd}
\alias{kbd}
\title{Generate the <kbd> HTML tag.}
\usage{
kbd(..., attr = NULL, separate = FALSE, collapse = "")
}
\arguments{
\item{...}{A string or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}
}
\value{
A HTML tag string.
}
\description{
The <kbd> HTML element represents a span of inline text denoting textual user input from a keyboard, voice input, or any other text entry device. By convention, the user agent defaults to rendering the contents of a <kbd> element using its default monospace font, although this is not mandated by the HTML standard.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/kbd}.
}
\examples{
kbd(attr = list(class = "test"))
}
