% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{audio}
\alias{audio}
\title{Generate the <audio> HTML tag.}
\usage{
audio(..., attr = NULL, separate = FALSE, collapse = "")
}
\arguments{
\item{...}{A string or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}
}
\value{
A HTML tag string.
}
\description{
The <audio> HTML element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the source element: the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio}.
}
\examples{
audio(attr = list(class = "test"))
}
