% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxtestClust.R
\name{wilcoxtestClust}
\alias{wilcoxtestClust}
\alias{wilcoxtestClust.default}
\alias{wilcoxtestClust.formula}
\title{Rank Sum and Signed Rank Tests for Clustered Data}
\usage{
wilcoxtestClust(x, ...)

\method{wilcoxtestClust}{default}(
  x,
  y = NULL,
  idx,
  idy = NULL,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  method = c("cluster", "group"),
  ...
)

\method{wilcoxtestClust}{formula}(formula, id, data, subset, na.action, ...)
}
\arguments{
\item{x, y}{numeric vectors of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{idx}{vector or factor object denoting cluster membership for \code{x} observations (or cluster
membership for paired observations when \code{paired} is \code{TRUE}). Length must be equal
to length of \code{x}.}

\item{idy}{vector or factor object denoting cluster membership for \code{y} observations. Length must be equal
to length of \code{y}}

\item{alternative}{indicates the alternative hypothesis and must be one of "\code{two.sided}", "\code{greater}",
or "\code{less}".You can specify just the initial letter.}

\item{mu}{a number specifying an optional parameter used to form the null hypothesis. Ignored when
performing a rank-sum test. See 'Details'.}

\item{paired}{a logical indicating whether \code{x} and \code{y} are paired. When \code{TRUE}, the
cluster-weighted signed rank test is performed.}

\item{method}{a character string specifying the method of rank sum test to be performed. See 'Details'.}

\item{formula}{a formula of the form \code{lhs} ~ \code{rhs}, where \code{lhs} is a numeric variable
giving the data values and \code{rhs} a numeric or factor with two levels giving the corresponding groups.}

\item{id}{a vector or factor object denoting cluster membership.}

\item{data}{an optional matrix or data frame containing variables in the formula \code{formula} and \code{id}.
By default the variables are taken from \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when data contain \code{NA}s. Defaults to
\code{getOption("na.action")}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{null.value}{the location parameter \code{mu}. Always 0 for rank sum test.}
\item{data.name}{a character string giving the name(s) of the data and the total number of clusters.}
\item{method}{a character string indicating the test performed and method of construction.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{M}{the number of clusters.}
}
\description{
Performs a one-sample or paired cluster-weighted signed rank test, or a cluster- or
group-weighted rank sum test. These tests are appropriate for clustered data with
potentially informative cluster size.
}
\details{
The formula interface is only applicable for the 2-sample rank-sum tests.

If only \code{x} and \code{idx} are given, a cluster-weighted signed rank test of the null that
the distribution of \code{x} is symmetric about \code{mu} is performed.

If \code{x} and \code{y} are given and \code{paired} is \code{TRUE}, only \code{idx} is necessary (\code{idy}
is ignored). In this case, a cluster-weighted signed-rank test of the null that the distribution of \code{x - y}
is symmetric about \code{mu} is performed.

When \code{method} is \code{cluster}, the cluster-weighted rank sum test of Datta and Satten (2005) is performed.
The data must have complete intra-cluster group distribution (i.e., all clusters must contain observations
belonging to both groups) for this test to be performed.

When \code{method} is \code{group}, the group-weighted rank-sum test of Dutta and Datta (2015) is performed.
This test is appropriate for clustered data with potentially informative intra-cluster group size. Incomplete
intra-cluster group distribution is permitted.

For the rank sum tests, the null is that the two groups follow the same marginal distribution. \code{mu} is
ignored when performing these tests.

The tests performed by this function involve computation of reweighted empirical CDFs. This is computationally
intensive and can result in lengthy execution time for large data sets.
}
\examples{
\donttest{
  data(screen8)
  ## One-sample signed rank test
  wilcoxtestClust(x=screen8$math, idx=screen8$sch.id, mu=70)

  ## Paired signed rank test
  wilcoxtestClust(x=screen8$math, y=screen8$read, idx=screen8$sch.id, paired=TRUE, mu=10)

  ## Cluster-weighted rank sum test
  wilcoxtestClust(math~gender, id=sch.id, data=screen8)


  ## Group-weighted rank sum test
  boys <- subset(screen8, gender=='M')
  girls <- subset(screen8, gender=='F')
  wilcoxtestClust(x=boys$math, y=girls$math, idx=boys$sch.id, idy=girls$sch.id, method="group")

  ## Group-weighted rank sum test using formula method
  wilcoxtestClust(math~gender, id=sch.id, data=screen8, method="group")
}
}
\references{
Datta, S., Satten, G. (2005) Rank-sum tests for clustered data.
\emph{J. Am. Stat. Assoc.}, \bold{100}, 908--915.

Datta, S., Satten, G. (2008) A signed-rank test for clustered data.
\emph{Biometrics}, \bold{64}, 501--507.

Dutta, S., Datta, S. (2015) A rank-sum test for clustered data when the number of subjects in a
group within a cluster is informative. \emph{Biometrics}, \bold{72}, 432--440.
}
