% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_viz.R
\name{warming_stripes}
\alias{warming_stripes}
\title{Download and plot essential climate data}
\usage{
warming_stripes(
  dataset = get_temp(),
  stripe_only = FALSE,
  col_strip = RColorBrewer::brewer.pal(11, "RdBu"),
  print = TRUE
)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_temp}}

\item{stripe_only}{Display legend and axes, defaults to TRUE}

\item{col_strip}{Color palette to use.  Defaults to Red-Blue RColorBrewer palette.}

\item{print}{(boolean) Display warming stripe ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with warming stripes
}
\description{
Plots global "warming stripes" graph in the style popularized by Ed Hawkins, based on temperature anomaly retrieved using \code{get_temp()}.
Function can output stripes chart with legend or a minimal chart. The output ggplot2 object may be further modified.
}
\details{
\code{warming_stripes} invisibly returns a ggplot2 object with warming stripes chart using data from \code{get_temp}.
By default the chart is also displayed. User may modify color palette or remove axes and legend. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Draw with axes and legend
stripes <- warming_stripes()

# Draw stripes only
stripes <- warming_stripes(stripe_only = TRUE)

# Don't display, store for further modifications
stripes <- warming_stripes(print = FALSE)

# Change color palette
stripes <- warming_stripes(stripe_only = TRUE, col_strip = viridisLite::viridis(11)) }

}
\references{
\itemize{
\item Climate Lab. 2018. https://www.climate-lab-book.ac.uk/2018/warming-stripes/
\item GISS Surface Temperature Analysis (GISTEMP v4): \url{https://data.giss.nasa.gov/gistemp/}
\item GISTEMP Team, 2020: \emph{GISS Surface Temperature Analysis (GISTEMP), version 4.} NASA Goddard Institute for Space Studies.
\item Dr. Dominic Roye blog post "How to Create Warming Stripes in R": https://dominicroye.github.io/en/2018/how-to-create-warming-stripes-in-r/
}
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
