% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_roundedcont_2017-12-27.R
\name{imp_roundedcont}
\alias{imp_roundedcont}
\title{The function to impute rounded continuous variables}
\usage{
imp_roundedcont(y, X, rounding_degrees = c(1, 10, 100, 1000))
}
\arguments{
\item{y}{A Vector with the variable to impute.}

\item{X}{A data.frame with the fixed effects variables.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
For example the income in surveys is often reported rounded by the respondents.
See Drechsler, Kiesl and Speidel (2015) for more details.
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions".
Austrian Journal of Statistics Vol. 44, No. 2, http://dx.doi.org/10.17713/ajs.v44i2.77
}
