% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_alphas_indept}
\alias{simulate_alphas_indept}
\title{Generate attribute trajectories under the simple independent-attribute learning model}
\usage{
simulate_alphas_indept(taus, alpha0s, L, R)
}
\arguments{
\item{taus}{A length K \code{vector} of transition probabilities from 0 to 1 on each skill}

\item{alpha0s}{An N-by-K \code{matrix} of subjects' initial attribute patterns.}

\item{L}{An \code{int} of number of time points}

\item{R}{A K-by-K dichotomous reachability \code{matrix} indicating the attribute hierarchies. The k,k'th entry of R is 1 if k' is prereq to k.}
}
\value{
An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point.
}
\description{
Based on the initial attribute patterns and probability of transitioning from 0 to 1 on each attribute,
create cube of attribute patterns of all subjects across time. Transitions on different skills are regarded as independent.
}
\examples{
N = length(Test_versions)
J = nrow(Q_matrix)
K = ncol(Q_matrix)
L = nrow(Test_order)
Jt = J/L
tau <- numeric(K)
for(k in 1:K){
  tau[k] <- runif(1,.2,.6)
}
R = matrix(0,K,K)
# Initial alphas
p_mastery <- c(.5,.5,.4,.4)
Alphas_0 <- matrix(0,N,K)
for(i in 1:N){
  for(k in 1:K){
    prereqs <- which(R[k,]==1)
    if(length(prereqs)==0){
      Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
    }
    if(length(prereqs)>0){
      Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
    }
  }
}
Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
}
