% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.accept.R
\name{mcmc.accept}
\alias{mcmc.accept}
\title{Acceptance ratio of the HKEVP fit}
\usage{
mcmc.accept(fit, plotted)
}
\arguments{
\item{fit}{A named list.
Output from the \code{hkevp.fit} procedure.}

\item{plotted}{Logical.
Whether or not the acceptance rates should be plotted.}
}
\value{
A named list with four elements:
\itemize{
\item \code{GEV}: A matrix of real values. Acceptance rates for each GEV parameter (columns) and each site position (rows).
\item \code{alpha}: A numerical value. Acceptance ratio for the dependence parameter \eqn{\alpha}.
\item \code{tau}: A numerical value. Acceptance ratio for the bandwidth parameter \eqn{\tau}.
\item \code{A}: A matrix of real values. Acceptance rates of the random effect for each knot position (rows) and each block (columns) where maxima are observed.
}
}
\description{
Computation and plot of the acceptance rates for each parameter of the HKEVP, from the output of the MCMC procedure.
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
mu <- sites[,1]*10
sigma <- 3
xi <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, mu, sigma, xi, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, knots, niter = 100, nburn = 50, quiet = FALSE)

# Acceptance rates:
# mcmc.accept(fit, TRUE)




}
\author{
Quentin Sebille
}
\seealso{
\link{mcmc.plot}
}

