% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/anova.R
\name{fast.anova}
\alias{fast.anova}
\title{Fast ANOVA}
\usage{
fast.anova(x, y, assign = NULL)
}
\arguments{
\item{x}{Design matrix of dimension \code{n * p}.}

\item{y}{Response vector of observations of length \code{n}.}

\item{assign}{Integer vector assigning columns to terms can be also given as
\code{x} attribute in which case the argument is ignored. If an intercept
exist it is expected to be the first column in \code{x} and here it has to
specified by a '0'. For details about assign see
\code{\link[stats]{model.matrix}}.}
}
\description{
A fast sequential analysis of variance (ANOVA). Mainly
developed for internal use.
}
\examples{
y <- rnorm(n = 100)
x <- matrix(data = rnorm(1000), nrow = 100)
a <- 1:10
fast.anova(x = x, y = y, assign = a)
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[stats]{anova}}, and
\code{\link[stats]{aov}}.
}

