% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hm_get_test}
\alias{hm_get_test}
\title{Get test data}
\source{
\url{https://datafinder.stats.govt.nz/layer/104266-territorial-authority-2020-clipped-generalised/}
}
\usage{
hm_get_test(item = c("coast", "buffer", "nofly", "grid", "route"))
}
\arguments{
\item{item}{Any one of \code{"coast", "buffer", "nofly", "grid", "route"}. See details.}
}
\value{
See list above
}
\description{
Access 5 datasets that are used in vignettes and in testing.
}
\details{
\describe{
  \item{\code{"coast"}}{A dataset containing sf::MULTIPOLYGONS for New Zealand. Simplified
  version of Stats NZ data, at 1km resolution.}
  \item{\code{"buffer"}}{As \code{"coast"} but with an added 30km buffer to keep supersonic
  flight away from the coast.}
  \item{\code{"nofly"}}{As \code{"buffer"}, but limited to Buller district with a 40km buffer.
  To test additional no-fly zones.}
  \item{\code{"grid"}}{Latitude-longitude-based routing grid around New Zealand at 30km target
distance, as generated by \code{\link{make_route_grid}}, so format is \linkS4class{GridLat}}
  \item{\code{"route"}}{Some very unlikely supersonic routes around New Zealand using the test
aircraft that was given a very short range and slow subsonic cruise to get
the example to 'work'. Includes one refuelling stop (!) in Wellington. [Not for operational use!]
Returns a dataframe.}
}

This is not the normal way to access package test data. But the usual, direct, way fails on
some machines that have some older software (a known feature of the `sf` package). This is a
least-ugly workaround.
}
\examples{
NZ_coast <- hm_get_test("coast")

}
