% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_div.R
\name{hill_div}
\alias{hill_div}
\title{Hill numbers computation}
\usage{
hill_div(count, qvalue, tree, dist)
}
\arguments{
\item{count}{A vector or a matrix/data.frame indicating the (relative) counts of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}

\item{qvalue}{A positive integer or decimal number (>=0), usually between 0 and 3.}

\item{tree}{An ultrametic tree of class 'phylo'. The tip labels must match the names of the vector values (if one sample) or matrix rows (if multiple samples). Use the function match_data() if the OTU names do not match.}

\item{dist}{A dist object indicating the pairwise distances between samples. NOT implemented yet}
}
\description{
Compute neutral or phylogenetic Hill numbers from a single sample (vector) or count table (matrix). Hill numbers or numbers equivalents of diversity indices are diversity measures that compute diversity in effective number of OTUs, i.e. the number of equally abundant OTUs that would be needed to give the same value of diversity.
}
\details{
Hill numbers computation
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
#One sample
bat.diet.sample <- bat.diet.otutable[,1]
hill_div(bat.diet.sample,0)
hill_div(bat.diet.sample,qvalue=1)
#One sample (phylogenetic)
names(bat.diet.sample) <- rownames(bat.diet.otutable)
hill_div(bat.diet.sample,1,bat.diet.tree)
#Multiple samples
hill_div(bat.diet.otutable,0)
#Incidence-based
bat.diet.otutable.incidence <- to.incidence(bat.diet.otutable,bat.diet.hierarchy)
hill_div(bat.diet.otutable.incidence,qvalue=1)
hill_div(to.incidence(bat.diet.otutable,bat.diet.hierarchy),1)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Jost, L. (2006). Entropy and diversity. Oikos, 113, 363-375.\cr\cr
Hill, M. O. (1973). Diversity and evenness: a unifying notation and its consequences. Ecology, 54, 427-432.
}
\seealso{
\code{\link{index_div}}, \code{\link{div_part}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{ASV}
\keyword{OTU}
\keyword{diversity}
