% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_filt.R
\name{copy_filt}
\alias{copy_filt}
\title{OTU/ASV copy number filtering}
\usage{
copy_filt(abund, threshold)
}
\arguments{
\item{abund}{A vector or a matrix/data.frame indicating the relative abundances of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}

\item{threshold}{An integer or a decimal number indicating the cut-off threshold. If an integer is provided, an absolute threshold is used (same threshold for all samples). If a decimal number is provided a relative copy number threshold is applied (dependent on the sequencing depth of each sample).}
}
\description{
As DNA sequencing data include PCR and sequencing errors, copy number thresholds are commonly applied to discard the OTUs with low number of sequence copies. This threshold can be absolute or (ideally) relative to the sequencing depth of each sample.
}
\details{
OTU/ASV copy number filtering
}
\examples{
data(bat.diet.otutable)
#Remove singletons from all samples
copy_filt(bat.diet.otutable,2)
#Remove OTUs represented by less than 0.01\% of the total reads per sample.
copy_filt(bat.diet.otutable,0.0001)
}
\references{
Alberdi A, Aizpurua O, Bohmann K, Gopalakrishnan S, Lynggaard C, Nielsen M, Gilbert MTP. 2019. Promises and pitfalls of using high-throughput sequencing for diet analysis. Molecular Ecology Resources, 19(2), 327-348.
}
\seealso{
\code{\link{depth_cov}}, \code{\link{tss}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{ASV}
\keyword{OTU}
\keyword{threshold}
