% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.cut.R
\name{make.cut}
\alias{make.cut}
\title{Generate Cutting Points for a Multidimensional Matrix}
\usage{
make.cut(mat, n = 5, count.lim = 40)
}
\arguments{
\item{mat}{the matrix to cut}

\item{n}{the number of cuts to generate (defaults to 5)}

\item{count.lim}{the minimum number of counts to consider for density (defaults to 40)}
}
\value{
a list of of cuts for each column in \code{mat}, see \emph{details}
}
\description{
For a given column \code{cur.ch} that belongs to a matrix, and a given number of cuts \code{n},
compute \code{n-1} bins using either fixed of combined limits
}
\details{
the fixed limits correspond to 5 equally spaced values over the range of the column.
   the combined limits take the local minima and maxima determined using the \code{\link{localMinima}}
   and \code{\link{localMaxima}} functions, to adjust the limits using the following algorithm:
     \itemize{
       \item define \code{d} as half the distance between 2 fixed limits
       \item merge local minima and local maxima that are closer than \code{d}
       \item if any fixed limit is closer to a local minima than \code{d}, move the fixed limit to the local minima;
             move the limits that are not been moved yet, and that are before and after the moved limit
             so that they are evenly spread; repeat until no fixed limit can be moved
       \item if some limits have been moved to a local minima, \strong{remove} limits that are closer than \code{d} to
             a local maxima; move the limits that are not been moved yet, and that are before and after
             the deleted limit so that they are evenly spread; repeat until no fixed limit can be moved
       \item if no limits has been moved to a local minima, move limits that are closer than \code{d} to
             a local maxima; move the limits that are not been moved yet, and that are before and after
             the moved limit so that they are evenly spread; repeat until no fixed limit can be moved
     }
   The function returns a list of lists, one for each column in \code{mat}, consisting of
     \itemize{
       \item \code{cur.dens} the density used to describe the data
       \item \code{cur.hist} the histogram used to describe the data
       \item \code{fixed} the fixed, evenly spaced cuts
       \item \code{minima} the local minima detected in the data
       \item \code{maxima} the local maxima detected in the data
       \item \code{combined} the cuts defined using a combination of fixed positions, local minima and local maxima
     }
}
\examples{
# generate a random 3D matrix with 2 peaks
mat <- rbind(matrix(rnorm(300),ncol=3),
             matrix(rnorm(300,5,1),ncol=3))
dimnames(mat)[[2]] <- LETTERS[1:3]
# estimate the Hilbert order
hilbert.order(mat)
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
}
\author{
Yann Abraham
}
