% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collocate_comments.R
\name{collocate_comments}
\alias{collocate_comments}
\title{Collocation of Comments}
\usage{
collocate_comments(transcript_token, note_token, collocate_length = 5)
}
\arguments{
\item{transcript_token}{transcript token to act as baseline for notes, resulting
from \code{\link[=token_transcript]{token_transcript()}}}

\item{note_token}{tokenized document of notes, resulting from \code{\link[=token_comments]{token_comments()}}}

\item{collocate_length}{the length of the collocation. Default is 5}
}
\value{
data frame of the transcript and corresponding note frequency
}
\description{
This function provides the frequency of collocations in comments that
correspond to the provided transcript.
}
\examples{
comment_example_rename <- dplyr::rename(comment_example, page_notes=Notes)
toks_comment <- token_comments(comment_example_rename[1:100,])
transcript_example_rename <- dplyr::rename(transcript_example, text=Text)
toks_transcript <- token_transcript(transcript_example_rename)
collocation_object <- collocate_comments(toks_transcript, toks_comment)

}
