% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot_vol_and_drift.R
\name{spotDrift}
\alias{spotDrift}
\title{Spot Drift Estimation}
\usage{
spotDrift(
  data,
  method = "driftMean",
  ...,
  on = "minutes",
  k = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = "GMT"
)
}
\arguments{
\item{data}{Can be one of two input types, \code{xts} or \code{data.table}. It is assumed that the input comprises prices in levels.}

\item{method}{Which method to be used to estimate the spot-drift. Currently, three methods are available, rolling mean and median as well as the kernel method of Christensen et al. 2018.
The kernel is a left hand exponential kernel that will weigh newer observations more heavily than older observations.}

\item{...}{Additional arguments for the individual methods. See details}

\item{on}{What time-frame should the estimator be applied? Accepted inputs are \code{"milliseconds"}, \code{"seconds"} and \code{"secs"} for seconds, \code{"minutes"} and \code{"mins"} for minutes, and \code{"hours"} for hours.
Standard is minutes}

\item{k}{How often should the estimation take place? If \code{k} is 5 the estimation will be done every fifth unit of \code{on}.}

\item{marketOpen}{Opening time of the market, standard is "09:30:00"}

\item{marketClose}{Closing time of the market, standard is "16:00:00"}

\item{tz}{Time zone, standard is "GMT"}
}
\value{
An object of class "spotDrift" containing at least the estimated spot drift process. Input on what this class should contain and methods for it is welcome.
}
\description{
Function used to estimate the spot drift of intraday (tick) stock prices/returns
}
\details{
The additional arguments for the mean and median methods are: \code{periods} for the rolling window length which is 5 by standard and
\code{align} to allow for control of the alignment, should one wish to do so, the standard is \code{"right"}. 
For the kernel mean estimator, the arguments \code{meanBandwidth} can be used to control the bandwidth of the drift estimator and the \code{preAverage} argument, which can be used to control the pre-averaging horizon. 
These arguments default to 300 and 5 respectively.
}
\examples{
# Example 1: Rolling mean and median estimators for 2 days
meandrift <- spotDrift(data = sampleTDataMicroseconds, k = 1, tz = "EST")
mediandrift <- spotDrift(data = sampleTDataMicroseconds, method = "driftMedian", 
                         on = "seconds", k = 30, tz = "EST")
plot(meandrift)
plot(mediandrift)

# Example 2: Kernel based estimator for one day
price <- sampleTData$PRICE
storage.mode(price) <- "numeric"
#kerneldrift <- spotDrift(price, method = "driftKernel", on = "minutes", k = 1)
#plot(kerneldrift)

}
\references{
Christensen, Oomen and Reno (2018): The drift burst hypothesis (working paper) <DOI:10.2139/ssrn.2842535>.
}
\author{
Emil Sjoerup
}
\keyword{Drift}
