% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{minRV}
\alias{minRV}
\title{minRV}
\usage{
minRV(rData, alignBy = NULL, alignPeriod = NULL, makeReturns = FALSE)
}
\arguments{
\item{rData}{a zoo/xts object containing all returns in period t for one asset.}

\item{alignBy}{a string, align the tick data to "seconds"|"minutes"|"hours".}

\item{alignPeriod}{an integer, align the tick data to this many [seconds|minutes|hours].}

\item{makeReturns}{boolean, should be TRUE when rData contains prices instead of returns. FALSE by default.}
}
\value{
numeric
}
\description{
Function returns the minRV, defined in Andersen et al. (2009).

Let \eqn{r_{t,i}} be a return (with \eqn{i=1,\ldots,M}) in period \eqn{t}.

Then, the minRV is given by
\deqn{
\mbox{minRV}_{t}=\frac{\pi}{\pi - 2}\left(\frac{M}{M-1}\right) \sum_{i=1}^{M-1} \mbox{min}(|r_{t,i}| ,|r_{t,i+1}|)^2
}
}
\examples{
data(sampleTData)
minrv <- minRV(rData = sampleTData$PRICE, alignBy = "minutes",
               alignPeriod = 5, makeReturns = TRUE)
minrv 

}
\references{
Andersen, T. G., D. Dobrev, and E. Schaumburg (2012). Jump-robust volatility estimation using nearest neighbor truncation. Journal of Econometrics, 169 (1), 75-93.
}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{volatility}
