% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rBeta}
\alias{rBeta}
\title{Realized beta: a tool in measuring risk with respect to the market.}
\usage{
rBeta(
  rdata,
  rindex,
  RCOVestimator = "rCov",
  RVestimator = "RV",
  makeReturns = FALSE
)
}
\arguments{
\item{rdata}{a zoo/xts object containing all returns in period t for one asset.}

\item{rindex}{a zoo/xts object containing return in period t for an index.}

\item{RCOVestimator}{can be chosen among realized covariance estimators: rCov, rAVGCov, rBPCov, rHYCov, rKernelCov, rOWCov, rRTSCov, rThresholdCov and rTSCov. rCov by default.}

\item{RVestimator}{can be chosen among realized variance estimators: RV, minRV and medRV. RV by default. In case of missing RVestimator, RCOVestimator function applying for rindex will be used.}

\item{makeReturns}{boolean, should be TRUE when rdata contains prices instead of returns. FALSE by  default.}
}
\value{
numeric
}
\description{
Depending on users' choices of estimator (realized covariance (RCOVestimator) and realized variance (RVestimator)), the function returns the realized beta, defined as the ratio between both.

The realized beta is given by
\deqn{
\beta_{jm} = \frac {RCOVestimator_{jm}}{RVestimator_{m}}
}

in which

\eqn{RCOVestimator:} Realized covariance of asset j and market index m.

\eqn{RVestimator:} Realized variance of market index m.
}
\details{
Suppose there are \eqn{N} equispaced returns on day \eqn{t} for the asset j and the index m. Denote \eqn{r_{(j)i,t}}, \eqn{r_{(m)i,t}} as the \eqn{i}th return on day \eqn{t} for asset \eqn{j} and index \eqn{m} (with \eqn{i=1, \ldots,N}).

By default, the RCov is used and the realized beta coefficient is computed as:  
\deqn{
\hat{\beta}_{(jm)t}= \frac{\sum_{i=1}^{N} r_{(j)i,t} r_{(m)i,t}}{\sum_{i=1}^{N} r_{(m)i,t}^2}
}
 
(Barndorff & Shephard (2004)).

Note: It is worth to note that the function does not support to calculate for data of multiple days.
}
\examples{
a <- sample_5minprices_jumps['2010-01-04', 1]
b <- sample_5minprices_jumps['2010-01-04', 2]
rBeta(a, b, RCOVestimator = "rBPCov", RVestimator = "minRV", makeReturns = TRUE)

}
\references{
Barndorff-Nielsen, O. E., & Shephard, N. (2004). Econometric analysis of realized covariation: High frequency based covariance, regression, and correlation in 
#' financial economics. Econometrica, 72(3), 885-925.
}
\author{
Giang Nguyen, Jonathan Cornelissen and Kris Boudt
}
\keyword{highfrequency}
\keyword{rBeta}
