% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{mergeTradesSameTimestamp}
\alias{mergeTradesSameTimestamp}
\title{Merge multiple transactions with the same time stamp}
\usage{
mergeTradesSameTimestamp(tdata, selection = "median")
}
\arguments{
\item{tdata}{an xts object containing the time series data, with 
one column named "PRICE" indicating the transaction price 
and one column "SIZE" indicating the number of shares traded.}

\item{selection}{indicates how the price for a certain time stamp
should be calculated in case of multiple observation for a certain time
stamp. By default, selection = "median", and the median price is taken. Alternatively:
\itemize{
\item selection = "max.volume": use the price of the transaction with
largest volume.
\item selection = "weighted.average": take the weighted average of all prices.
}}
}
\value{
data.table or xts object depending on input
}
\description{
Function replaces multiple transactions that have the same time stamp by a single one and returns an xts or data.table object with unique time stamps only.
}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{cleaning}
