% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simgenot_new.R
\name{sim.genot.t}
\alias{sim.genot.t}
\title{Simulate data from a non equilibrium continent-island model}
\usage{
sim.genot.t(size=50,nbal=4,nbloc=5,nbpop=3,N=1000,
mig=0.001,mut=0.0001,f=0,t=100,IIM=TRUE)
}
\arguments{
\item{size}{the number of sampled individuals per island}

\item{nbal}{the number of alleles per locus (maximum of 99)}

\item{nbloc}{the number of loci to simulate}

\item{nbpop}{the number of islands to simulate}

\item{N}{the effective population sizes of each island. If only one number, all
islands are assumed to be of the same size}

\item{mig}{the migration rate from the continent to the islands}

\item{mut}{the mutation rate of the loci}

\item{f}{the inbreeding coefficient for each island}

\item{t}{the number of generation since the islands were created}

\item{IIM}{whether to simulate a continent island Model (default) or a migrant pool island Model}
}
\value{
A data frame with size*nbpop rows and nbloc+1 columns. Each row is an
individual, the first column contains the island to which the individual belongs, 
the following nbloc columns contain the genotype for each locus.
}
\description{
This function allows to simulate genetic data from a non-equilibrium continent-island
 model, where each island can have a different size and a different inbreeding 
 coefficient. 
 
 This function simulates genetic data under the continent-islands model (IIM=TRUE) 
or the finite island model (IIM=FALSE).
 In the IIM, a continent of 
 infinite size sends migrants to islands of finite sizes \eqn{N_i} at a rate 
\eqn{m}. Alleles can also mutate to a new state at a rate \eqn{\mu}. Under this model, 
 the expected \eqn{F_{STi}, \theta_i}, can be calculated and compared to empirical
 estimates.
}
\details{
In this model, \eqn{\theta_t} can be written as a function of population size 
\eqn{N_i}, migration rate \eqn{m}, mutation rate \eqn{\mu} and \eqn{\theta_{(t-1)}}.

The rational is as follows:
 
 With probability \eqn{\frac{1}{N}}, 2 alleles from 2 different individuals in 
 the current generation are sampled from the same individual of the previous 
 generation:     
 
 -Half the time, the same allele is drawn from the parent;
  
 -The other half, two different alleles are drawn, but they are identical in 
 proportion \eqn{\theta_{(t-1)}}.
  
 -With  probability \eqn{1-\frac{1}{N}}, the 2 alleles are drawn from different 
 individuals in the previous generation, in which case they are identical in 
 proportion \eqn{\theta_{(t-1)}}.
 
 This holds providing that neither alleles have mutated or migrated.  This is 
 the case with probability \eqn{(1-m)^2 \times (1-\mu)^2}.
 If an allele is a mutant or a migrant, then its coancestry with another allele 
 is 0 in the infinite continent-islands model (it is not the case in the finite island model).

Note also that the mutation scheme assumed is the infinite allele (or site) 
model.  If the number of alleles is finite (as will be the case in what follows),
the corresponding mutation model is the K-allele model and the mutation rate 
has to be adjusted to \eqn{\mu'=\frac{K-1}{K}\mu}.

Lets substitute \eqn{\alpha} for  \eqn{(1-m)^2 (1-\mu)^2} and \eqn{x} for
 \eqn{\frac{1}{2N}}.

The expectation of \eqn{F_{ST}}, \eqn{\theta} can be written as:

\deqn{\theta_t=(\alpha (1-x))^t \theta_0 + \frac{x}{1-x}\sum_{i=1}^t (\alpha (1-x))^i}

which reduces to \eqn{\theta_t=\frac{x}{1-x}\sum_{i=1}^t (\alpha (1-x))^i} if \eqn{\theta_0=0}.
 
 Transition equations for \eqn{theta} in the migrant-pool island model (IIM=FALSE) are given in Rouseet (1996). 
 Currently, the migrant pool is made of equal contribution from each island, irrespective of their size.
}
\examples{

psize<-c(100,1000,10000,100000,1000000)
dat<-sim.genot.t(nbal=4,nbloc=20,nbpop=5,N=psize,mig=0.001,mut=0.0001,t=100)
summary(wc(dat)) #Weir and cockerham overall estimators of FST & FIS
betas(dat) # Population specific estimator of FST

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/8846911}{Rousset, F. (1996)} Equilibrium values of measures of population subdivision for 
 stepwise mutation processes. Genetics 142:1357
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
