% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstat2dos.R
\name{biall2dos}
\alias{biall2dos}
\title{Converts bi-allelic SNPs from hierfstat format to dosage format}
\usage{
biall2dos(dat,diploid=TRUE)
}
\arguments{
\item{dat}{a hierfstat data frame without the first column (the population identifier), 
individuals in rows, columns with individual genotypes encoded as 11, 12, 21 and 22}

\item{diploid}{whether the data set is from a diploid organism}
}
\value{
a matrix containing allelic dosages
}
\description{
Converts bi-allelic SNPs hierfstat format to dosage format, the number of alternate allele copies at a locus
for an individual, i.e. 11 -> 0; 12 or 21 >1 and 22 ->2
}
\examples{
\dontrun{
biall2dos(sim.genot(nbal=2,nbloc=10)[,-1])  # a 10 column matrix
}

}
