% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeped.R
\name{write.ped}
\alias{write.ped}
\title{Write ped file for analyses with PLINK}
\usage{
write.ped(dat, ilab = NULL, pop = NULL, 
        fname = "dat",na.str="0",f.id=NULL,m.id=NULL,loc.pos=NULL,sex=NULL)
}
\arguments{
\item{dat}{a hierfstat data frame. if pop=NULL, the first column should contain the population identifier, 
otherwise it contains genotypes at the first locus}

\item{ilab}{individual labels}

\item{pop}{population id}

\item{fname}{filename for ped file}

\item{na.str}{character string to use for missing values}

\item{f.id}{father id. default to unknown}

\item{m.id}{mother id. default to unknown}

\item{loc.pos}{the loci position default to unknown}

\item{sex}{the individual sex. default to unknown}
}
\value{
a map file containing the loci positions

a ped file containing genotypes etc...
}
\description{
write a ped and a map file suitable for analysis with 
\href{https://www.cog-genomics.org/plink2}{PLINK}
}
\references{
\href{https://academic.oup.com/gigascience/article/4/1/s13742-015-0047-8/2707533}{Chang et al. (2015)} 
Second-generation PLINK: rising to the challenge of larger and richer datasets
}
