% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readQN.R
\name{qn2.read.fstat}
\alias{qn2.read.fstat}
\title{Read QuantiNemo extended format for genotype files}
\usage{
qn2.read.fstat(fname, na.s = c("NA","NaN"))
}
\arguments{
\item{fname}{quantinemo file name}

\item{na.s}{na string used}
}
\value{
dat  a data frame with nloc+1 columns, the first being the population
 to which the individual belongs and the next being the genotypes, one column per locus;
 and ninds rows

sex  the sex of the individuals
}
\description{
Read QuantiNemo (\url{http://www2.unil.ch/popgen/softwares/quantinemo/}) genotype files extended format (option 2)
}
\examples{
dat<-qn2.read.fstat(system.file("extdata","qn2_sex.dat",package="hierfstat"))
  sexbias.test(dat[[1]],sex=dat[[2]])
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
\references{
\href{http://www2.unil.ch/popgen/softwares/quantinemo/2008_Neuenschwander_et_al_BioInf_quantiNEMO.pdf}{Neuenschwander S, Hospital F, Guillaume F, Goudet J (2008)}
 quantiNEMO: an individual-based program to simulate quantitative traits with explicit
 genetic architecture in a dynamic metapopulation Bioinformatics 24, 1552-1553.
}
\seealso{
\code{\link{read.fstat}}
}

