% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hiscr.R
\name{hiscr}
\alias{hiscr}
\title{Calculates HiSCR scores given a percentage parameter.}
\usage{
hiscr(
  baseline_abscess,
  baseline_nodule,
  baseline_fistula,
  timepoint_abscess,
  timepoint_nodule,
  timepoint_fistula,
  percentage
)
}
\arguments{
\item{baseline_abscess}{Integer vector representing the abscess count at
baseline.}

\item{baseline_nodule}{Integer vector representing the inflammatory nodule
count at baseline.}

\item{baseline_fistula}{Integer vector representing the draining fistula
count at baseline.}

\item{timepoint_abscess}{Integer vector representing the abscess count at the
time point of interest.}

\item{timepoint_nodule}{Integer vector representing the inflammatory nodule
count at the time point of interest.}

\item{timepoint_fistula}{Integer vector representing the draining fistula
count at the time point of interest.}

\item{percentage}{Numeric value specifying the percentage required for HiSCR
(e.g., 50 for HiSCR50, 75 for HiSCR75, etc.).}
}
\value{
A logical vector indicating whether the HiSCR response is achieved
for each set of input parameters.
}
\description{
Calculates HiSCR scores given a percentage parameter.
}
\examples{
hiscr(
  baseline_abscess = c(3, 2, 4),
  baseline_nodule = c(5, 4, 6),
  baseline_fistula = c(2, 1, 3),
  timepoint_abscess = c(1, 1, 2),
  timepoint_nodule = c(2, 3, 2),
  timepoint_fistula = c(2, 1, 3),
  percentage = 50
)
}
\references{
Kimball, A B et al. “HiSCR (Hidradenitis Suppurativa Clinical
Response): a novel clinical endpoint to evaluate therapeutic outcomes in
patients with hidradenitis suppurativa from the placebo-controlled portion
of a phase 2 adalimumab study.” Journal of the European Academy of
Dermatology and Venereology : JEADV vol. 30,6 (2016): 989-94.
doi:10.1111/jdv.13216
}
