% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_reflect_feature_space.R
\name{hhcart_reflect_feature_space_g}
\alias{hhcart_reflect_feature_space_g}
\title{hhcart_reflect_feature_space_g}
\usage{
hhcart_reflect_feature_space_g(
  X,
  y,
  useIdentity = FALSE,
  max_features = "None",
  n_features = n_features,
  n_classes = n_classes,
  classify = TRUE,
  depth = depth,
  colx = 1
)
}
\arguments{
\item{X}{The feature variables of the current node being processed.}

\item{y}{The target variable for the corresponding feature variables.}

\item{useIdentity}{A flag, if FALSE the node split will be done using an oblique split
after transforming the training data using a householder transform. If TRUE the 'transform'
will be the identity and the split will be done on the original data.}

\item{max_features}{The maximum number of features to consider in the current split.}

\item{n_features}{The number of feature variables.}

\item{n_classes}{The number of classes in the target variable.}

\item{classify}{A flag, if TRUE this is a classification problem, if FALSE this is a regression
problem.}

\item{depth}{The current tree depth.}

\item{colx}{The eigenvector column to use.}
}
\value{
Returns a list containing idx, thr, X_house, householder_matrix, using_householder if split
        was for a classification problem and reflected data used, otherwise the results from
        split_using_original_data are returned if useIdentity was TRUE. For a regression problem
        a list containing the following is returned: idx, thr, as.matrix(X), NULL, FALSE.
}
\description{
This function is in an internal only function. It is used to reflect the feature data if the
data is found to be suitable, otherwise node splitting will be done using the original data
and using axis-parallel splits.
}
\details{
The following parameters are supported:

X_matrix, X, y, most_freq_class, n_classes, max_features, n_features, colx
}
