% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sticker.R
\name{sticker}
\alias{sticker}
\title{sticker}
\usage{
sticker(subplot, s_x = 0.8, s_y = 0.75, s_width = 0.4, s_height = 0.5,
  package, p_x = 1, p_y = 1.4, p_color = "#FFFFFF",
  p_family = "Aller_Rg", p_size = 8, h_size = 1.2, h_fill = "#1881C2",
  h_color = "#87B13F", spotlight = FALSE, l_x = 1, l_y = 0.5,
  l_width = 3, l_height = 3, l_alpha = 0.4, url = "", u_x = 1,
  u_y = 0.08, u_color = "black", u_family = "Aller_Rg", u_size = 1.5,
  filename = paste0(package, ".png"))
}
\arguments{
\item{subplot}{subplot}

\item{s_x}{x position for subplot}

\item{s_y}{y position for subplot}

\item{s_width}{width for subplot}

\item{s_height}{height for subplot}

\item{package}{package name}

\item{p_x}{x position for package name}

\item{p_y}{y position for package name}

\item{p_color}{color for package name}

\item{p_family}{font family for package name}

\item{p_size}{font size for package name}

\item{h_size}{size for hexagon border}

\item{h_fill}{color to fill hexagon}

\item{h_color}{color for hexagon boder}

\item{spotlight}{whether add spotlight}

\item{l_x}{x position for spotlight}

\item{l_y}{y positioin for spotlight}

\item{l_width}{width for spotlight}

\item{l_height}{height for spotlight}

\item{l_alpha}{maximum alpha for spotlight}

\item{url}{url at lower border}

\item{u_x}{x position for url}

\item{u_y}{y position for url}

\item{u_color}{color for url}

\item{u_family}{font family for url}

\item{u_size}{text size for url}

\item{filename}{filename to save sticker}
}
\value{
gg object
}
\description{
create sticker in R
}
\examples{
library(ggplot2)
p <- ggplot(aes(x = mpg, y = wt), data = mtcars) + geom_point()
p <- p + theme_void() + theme_transparent()
sticker(p, package="hexSticker")
}
\author{
guangchuang yu
}
