% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetu.R
\name{hetu}
\alias{hetu}
\title{Generic Extraction Tool for Finnish Personal Identity Codes}
\usage{
hetu(pin, extract = NULL, allow.temp = FALSE, diagnostic = FALSE)
}
\arguments{
\item{pin}{Finnish personal identity code(s) as a character vector}

\item{extract}{Extract only selected part of the information.
Valid values are "\code{hetu}", "\code{sex}", "\code{p.num}",
"\code{ctrl.char}", "\code{date}", "\code{day}", "\code{month}",
"\code{year}", "\code{century}", "\code{is.temp}".
If \code{NULL} (default), returns all information.}

\item{allow.temp}{Allow artificial or temporary PINs (personal numbers
900-999). If \code{FALSE} (default), only PINs intended for official
use (personal numbers 002-899) are allowed.}

\item{diagnostic}{Print additional information about possible problems in
PINs. The checks are "\code{valid.p.num}", "\code{valid.ctrl.char}",
"\code{correct.ctrl.char}", "\code{valid.date}", "\code{valid.day}",
"\code{valid.month}", "\code{valid.length}", "\code{valid.century}".
Default is \code{FALSE} which returns no diagnostic information.}
}
\value{
Finnish personal identity code data.frame,
    or if extract parameter is set, the requested part of the
   information as a vector. Returns an error or \code{NA} if the given
   character vector is not a valid Finnish personal identity code.
\item{hetu}{Finnish personal identity code as a character vector.
    A correct pin should be in the form DDMMYYCZZZQ, where DDMMYY stands for
    date, C for century sign, ZZZ for personal number and Q for control
    character.}
\item{sex}{sex of the person as a character vector ("Male" or "Female").}
\item{p.num}{Personal number part of the identity code.}
\item{ctrl.char}{Control character for the personal identity code.}
\item{date}{Birthdate.}
\item{day}{Day of the birthdate.}
\item{month}{Month of the birthdate.}
\item{year}{Year of the birthdate.}
\item{century}{Century character of the birthdate: + (1800), - (1900) or
   A (2000).}
\item{valid.pin}{Does the personal identity code pass all validity
   checks: (\code{TRUE} or \code{FALSE})}
}
\description{
Extract embedded information from Finnish personal identity
   codes (hetu).
}
\examples{
hetu("111111-111C")
hetu("111111-111C")$date
hetu("111111-111C")$sex
# Same as previous, but using extract argument
hetu("111111-111C", extract="sex")
# Process a vector of hetu's
hetu(c("010101-0101", "111111-111C"))
# Process a vector of hetu's and extract sex information from each
hetu(c("010101-0101", "111111-111C"), extract="sex")

}
\seealso{
\code{\link{pin_ctrl}} For validating Finnish personal
   identity codes.
}
\author{
Pyry Kantanen, Jussi Paananen
}
