% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{create_PsmCurves}
\alias{create_PsmCurves}
\alias{create_PsmCurves.flexsurvreg_list}
\alias{create_PsmCurves.params_surv_list}
\title{Create \code{PsmCurves} object}
\usage{
create_PsmCurves(object, ...)

\method{create_PsmCurves}{flexsurvreg_list}(
  object,
  input_data,
  n = 1000,
  uncertainty = c("normal", "bootstrap", "none"),
  est_data = NULL,
  ...
)

\method{create_PsmCurves}{params_surv_list}(object, input_data, ...)
}
\arguments{
\item{object}{Fitted survival models.}

\item{...}{Further arguments passed to or from other methods. Passed to \code{\link[=create_params.partsurvfit]{create_params.partsurvfit()}}
when \code{object} is of class \code{\link{flexsurvreg_list}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link{expand.hesim_data}}. Must be expanded by the data tables "strategies" and
"patients".}

\item{n}{Number of random observations of the parameters to draw.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled. See
documentation in \code{\link[=create_params]{create_params()}}.}

\item{est_data}{A \code{data.table} or \code{data.frame} of estimation data
used to fit survival models during bootstrap replications.}
}
\value{
Returns an \code{R6Class} object of class \code{\link{PsmCurves}}.
}
\description{
\code{create_PsmCurves} is a function for creating an object of class
\code{\link{PsmCurves}}.
}
\seealso{
\code{\link{PsmCurves}}
}
