% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{HERE Geocoding & Search API: Geocode}
\usage{
geocode(address, alternatives = FALSE, sf = TRUE, url_only = FALSE)
}
\arguments{
\item{address}{character, addresses to geocode or a list containing qualified queries with the keys "country", "state", "county", "city", "district", "street", "houseNumber" or "postalCode".}

\item{alternatives}{boolean, return also alternative results (\code{default = FALSE})?}

\item{sf}{boolean, return an \code{sf} object (\code{default = TRUE}) or a
\code{data.frame}?}

\item{url_only}{boolean, only return the generated URLs (\code{default =
FALSE})?}
}
\value{
If \code{sf = TRUE}, an \code{sf} object, containing the position coordinates
geocoded addresses as geometry list column and the access coordinates as
well-known text (WKT).
If \code{sf = FALSE}, a \code{data.frame} containing the coordinates of the
geocoded addresses as \code{lng}, \code{lat} columns.

According to the Geocoding and Search API Reference, the access coordinates
are "[c]oordinates of the place you are navigating to (for example, driving
or walking). This is a point on a road or in a parking lot." The position
coordinates are "[t]he coordinates (latitude, longitude) of a pin on a map
corresponding to the searched place."
}
\description{
Geocodes addresses using the HERE 'Geocoding & Search API' API.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

locs <- geocode(address = poi$city, url_only = TRUE)
}
\references{
\href{https://www.here.com/docs/bundle/geocoding-and-search-api-v7-api-reference/page/index.html}{HERE Geocoding & Search API: Geocode}
}
