% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_wheel.R
\name{draw_wheel}
\alias{draw_wheel}
\title{Create helical wheels to visualize alpha helical sequences.}
\usage{
draw_wheel(sequence, col = c("grey", "yellow", "blue", "red"))
}
\arguments{
\item{sequence}{character vector containing amino acid sequence
from N-terminus to C-terminus}

\item{col}{colors for each amino acid type in the following order:
nonpolar residues, polar residues, basic residues, acidic residues}
}
\description{
This function visualizes alpha-helical peptides as
helical wheels.
Sequences between 2 and 18 (inclusive) characters can be visualized.
The residue in the upper half of the wheel lying at the horizontal
center representing the amino acid at the N-terminus (first in `sequence`).
}
\examples{
draw_wheel("GIGAVLKVLTTGLPALIS")
draw_wheel("QQRKRKIWSILAPLGTTL")
}
