% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_obj}
\alias{kmeans_obj}
\title{K-Means Functions}
\usage{
kmeans_obj(.data, .centers = 5)
}
\arguments{
\item{.data}{The data that gets passed from \code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}}}

\item{.centers}{How many initial centers to start with}
}
\value{
A stats k-means object
}
\description{
Takes the output of the \code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}} function and applies the
k-means algorithm to it using \code{\link[stats:kmeans]{stats::kmeans()}}
}
\details{
Uses the \code{\link[stats:kmeans]{stats::kmeans()}} function and creates a wrapper around it.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

 kmeans_user_item_tbl(data_tbl, service_line, payer_grouping) \%>\%
   kmeans_obj()

}
\author{
Steven P. Sanderson II, MPH
}
