% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-date-time.R
\name{splitOutDateTimeCols}
\alias{splitOutDateTimeCols}
\title{Splits datetime column into multiple date features}
\usage{
splitOutDateTimeCols(df, dateTimeCol, depth = "h", returnDtCol = FALSE,
  format = "\%Y-\%m-\%d \%H:\%M:\%S")
}
\arguments{
\item{df}{A data frame. Indicates the datetime column.}

\item{dateTimeCol}{A string. Column name in df that will be converted
into several columns.}

\item{depth}{A string. Specifies the depth with which to expand extra columns
(starting with a year column). 'd' expands to day, 'h' expands to hour
(default), 'm' expands to minute, and 's' expands to second.}

\item{returnDtCol}{A boolean. Return the original dateTimeCol with
the modified data frame?}

\item{format}{A character string giving a date-time format as used by 
\code{\link{strptime}}. Default is '\%Y-\%m-\%d \%H:\%M:\%S'. If depth is 'h', 'm',
or 's', the format must include an '\%H:\%M:\%S' format structure to return those values.}
}
\value{
A data frame which now includes several columns based on time
rather than just one datetime column
}
\description{
Splits datetime column into columns of day, hour, etc, such that one
can use daily and seasonal patterns in their model building.
}
\examples{
df <- data.frame(
  dtCol = c('2001-06-09 12:45:05', '2002-01-29 09:30:05','2002-02-02 07:36:50',
            '2002-03-04 16:45:01','2002-11-13 20:00:10','2003-01-29 07:31:43',
            '2003-07-07 17:30:02','2003-09-28 01:03:20'),
  y1 = c(.5, 1, 3, 6, 8, 13, 14, 1),
  y2 = c(.8, 1, 1.2, 1.2, 1.2, 1.3, 1.3, 1)
)
splitOutDateTimeCols(df, 'dtCol')
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
